/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.minecolonies.api.util.Log;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public final class LootTableAnalyzer {
    private LootTableAnalyzer() {
    }

    private static JsonObject getLootTableJson(@NotNull LootTableManager lootTableManager, @NotNull ResourceLocation lootTableId) {
        LootTable lootTable = lootTableManager.func_186521_a(lootTableId);
        return LootTableManager.func_215301_a((LootTable)lootTable).getAsJsonObject();
    }

    public static List<LootDrop> toDrops(@NotNull LootTableManager lootTableManager, @NotNull ResourceLocation lootTableId) {
        try {
            JsonObject lootTableJson = LootTableAnalyzer.getLootTableJson(lootTableManager, lootTableId);
            return LootTableAnalyzer.toDrops(lootTableManager, lootTableJson);
        }
        catch (JsonParseException ex) {
            Log.getLogger().error(String.format("Failed to parse loot table from %s", lootTableId.toString()), (Throwable)ex);
            return Collections.emptyList();
        }
    }

    public static List<LootDrop> toDrops(@NotNull LootTableManager lootTableManager, @NotNull JsonObject lootTableJson) {
        ArrayList<LootDrop> drops = new ArrayList<LootDrop>();
        if (!lootTableJson.has("pools")) {
            return drops;
        }
        JsonArray pools = JSONUtils.func_151214_t((JsonObject)lootTableJson, (String)"pools");
        for (JsonElement pool : pools) {
            JsonArray entries = JSONUtils.func_151213_a((JsonObject)pool.getAsJsonObject(), (String)"entries", (JsonArray)new JsonArray());
            float totalWeight = StreamSupport.stream(entries.spliterator(), false).filter(entry -> {
                String type = JSONUtils.func_151200_h((JsonObject)entry.getAsJsonObject(), (String)"type");
                return type.equals("minecraft:empty") || type.equals("minecraft:item") || type.equals("minecraft:tag") || type.equals("minecraft:loot_table");
            }).mapToInt(entry -> JSONUtils.func_151208_a((JsonObject)entry.getAsJsonObject(), (String)"weight", (int)1)).sum();
            for (JsonElement ej : entries) {
                JsonObject entryJson = ej.getAsJsonObject();
                String type = JSONUtils.func_151200_h((JsonObject)entryJson, (String)"type");
                if (type.equals("minecraft:item")) {
                    Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)entryJson, (String)"name")));
                    float weight = JSONUtils.func_151221_a((JsonObject)entryJson, (String)"weight", (float)1.0f);
                    boolean variableQuality = JSONUtils.func_151221_a((JsonObject)entryJson, (String)"quality", (float)0.0f) != 0.0f;
                    ItemStack stack = new ItemStack((IItemProvider)item);
                    if (entryJson.has("functions")) {
                        LootTableAnalyzer.processFunctions(stack, JSONUtils.func_151214_t((JsonObject)entryJson, (String)"functions"));
                    }
                    drops.add(new LootDrop(Collections.singletonList(stack), weight / totalWeight, variableQuality));
                    continue;
                }
                if (!type.equals("minecraft:loot_table")) continue;
                ResourceLocation table = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)entryJson, (String)"name"));
                drops.addAll(LootTableAnalyzer.toDrops(lootTableManager, table));
            }
        }
        drops.sort(Comparator.comparing(LootDrop::getProbability).reversed());
        return drops;
    }

    @NotNull
    public static List<LootDrop> consolidate(@NotNull List<LootDrop> input) {
        return input.stream().collect(Collectors.groupingBy(LootDrop::hashCode)).values().stream().map(LootDrop::new).sorted(Comparator.comparing(LootDrop::getProbability).reversed()).collect(Collectors.toList());
    }

    private static void processFunctions(@NotNull ItemStack stack, @NotNull JsonArray functions) {
        for (JsonElement je : functions) {
            JsonObject function = je.getAsJsonObject();
            switch (JSONUtils.func_151200_h((JsonObject)function, (String)"function")) {
                case "minecraft:set_nbt": {
                    try {
                        stack.func_77982_d(JsonToNBT.func_180713_a((String)JSONUtils.func_151200_h((JsonObject)function, (String)"tag")));
                        break;
                    }
                    catch (CommandSyntaxException e) {
                        Log.getLogger().error("Failed to parse set_nbt in loot table", (Throwable)e);
                    }
                }
            }
        }
    }

    public static class LootDrop {
        private final List<ItemStack> stacks;
        private final float probability;
        private final boolean variableQuality;

        public LootDrop(@NotNull List<ItemStack> stacks, float probability, boolean variableQuality) {
            this.stacks = stacks;
            this.probability = probability;
            this.variableQuality = variableQuality;
        }

        public LootDrop(@NotNull List<LootDrop> drops) {
            this.stacks = drops.stream().flatMap(d -> d.getItemStacks().stream()).collect(Collectors.toList());
            this.probability = drops.get(0).getProbability();
            this.variableQuality = drops.get(0).getVariableQuality();
        }

        @NotNull
        public List<ItemStack> getItemStacks() {
            return this.stacks;
        }

        public float getProbability() {
            return this.probability;
        }

        public boolean getVariableQuality() {
            return this.variableQuality;
        }

        public int hashCode() {
            return Objects.hash(Float.valueOf(this.probability), this.variableQuality);
        }

        public void serialize(@NotNull PacketBuffer buffer) {
            buffer.func_150787_b(this.stacks.size());
            for (ItemStack stack : this.stacks) {
                buffer.func_150788_a(stack);
            }
            buffer.writeFloat(this.probability);
            buffer.writeBoolean(this.variableQuality);
        }

        public static LootDrop deserialize(@NotNull PacketBuffer buffer) {
            int size = buffer.func_150792_a();
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(size);
            for (int i = 0; i < size; ++i) {
                stacks.add(buffer.func_150791_c());
            }
            float probability = buffer.readFloat();
            boolean variableQuality = buffer.readBoolean();
            return new LootDrop(stacks, probability, variableQuality);
        }
    }
}

